<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<style>
/* საერთო სტილი ცხრილისთვის */
table.mytable {
    width: 100%;
    border-collapse: collapse;
    margin: 20px 0;
    font-family: Arial, sans-serif;
    background-color: #f9f9f9;
    box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
}
table.mytable th, table.mytable td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #ddd;
}
table.mytable tr:nth-child(even) {
    background-color: #f2f2f2;
}
table.mytable tr:hover {
    background-color: #f1f1f1;
}
table.mytable th {
    background-color: #4CAF50;
    color: white;
    font-weight: bold;
}
table.mytable td {
    color: #333;
}
table.mytable td.s1 {
    font-size: 14px;
    font-weight: normal;
}
table.mytable caption {
    font-size: 18px;
    font-weight: bold;
    padding: 10px 0;
    color: #333;
    text-align: left;
}
@media screen and (max-width: 600px) {
    table.mytable th, table.mytable td {
        padding: 8px 10px;
    }
}
</style>
</head>
<body>

<table id="table6" class="mytable" width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr>
    <th width="110px">პირადი</th>
    <th>ახალი</th>
    <th>ძველი</th>
    <th>ცვლილება</th>
    <th width="90px">პერიოდი</th>
    <th>მიზეზი</th>
    <th>გამოწერის თარიღი</th>
  </tr>

<?php
include '../13061981.php'; // შენი მონაცემთა ბაზის კავშირი
mysqli_set_charset($connection, 'utf8');

// პაგინაციის პარამეტრები
$limit = 500;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// SQL შეკითხვა
$sql = "
  SELECT 
    h.pn AS pn, 
    h.status AS new_status, 
    m.statusn AS old_status, 
    h.period AS period, 
    h.reason AS reason,
    h.date AS subscription_date
  FROM socebi2 m
  INNER JOIN socebi h ON TRIM(m.pnn) = TRIM(h.pn)
  LIMIT $limit OFFSET $offset
";

$result = mysqli_query($connection, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $pn = $row['pn'];
        $old_status = $row['old_status'];
        $new_status = $row['new_status'];
        $period = $row['period'];
        $reason = $row['reason'];
        $subscription_date = $row['subscription_date'];

        $change = (trim($old_status) !== trim($new_status)) ? "შეიცვალა" : "არ შეცვლილა";
?>
  <tr>
    <td class="s1"><?php echo htmlspecialchars($pn); ?></td>
    <td class="s1"><?php echo htmlspecialchars($new_status); ?></td>
    <td class="s1"><?php echo htmlspecialchars($old_status); ?></td>
    <td class="s1"><?php echo $change; ?></td>
    <td class="s1"><?php echo htmlspecialchars($period); ?></td>
    <td class="s1"><?php echo htmlspecialchars($reason); ?></td>
    <td class="s1"><?php echo htmlspecialchars($subscription_date); ?></td>
  </tr>
<?php 
    }
} else {
    echo "<tr><td colspan='7'>მონაცემები ვერ მოიძებნა ან ცარიელია.</td></tr>";
}
?>
</table>

<div style="text-align:center; margin-top:10px;">
<?php if ($page > 1): ?>
  <a href="?page=<?php echo $page - 1 ?>">← წინა</a> |
<?php endif; ?>
  <a href="?page=<?php echo $page + 1 ?>">შემდეგი →</a>
</div>

</body>
</html>
