<!DOCTYPE html>
<html lang="ka">
<head>
  <meta charset="UTF-8">
  <title>დეტალები</title>
  <style>
    table.mytable {
      width: 100%;
      border-collapse: collapse;
      margin: 20px 0;
      font-family: Arial, sans-serif;
      background-color: #f9f9f9;
      box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
    }
    table.mytable th, table.mytable td {
      padding: 10px;
      border-bottom: 1px solid #ddd;
    }
    table.mytable th {
      background-color: #4CAF50;
      color: white;
    }
    .loader {
      text-align: center;
      padding: 10px;
      color: #555;
    }
  </style>
</head>
<body>

<table class="mytable" id="data-table">
  <thead>
    <tr>
      <th>პირადი</th>
      <th>ახალი</th>
      <th>ძველი</th>
      <th>ცვლილება</th>
      <th>პერიოდი</th>
      <th>მიზეზი</th>
      <th>გამოწერის თარიღი</th>
    </tr>
  </thead>
  <tbody id="table-body">
    <!-- AJAX შევსება აქ მოხდება -->
  </tbody>
</table>

<div id="loader" class="loader">იტვირთება...</div>

<script>
let page = 1;
let loading = false;
const loader = document.getElementById("loader");

function loadData() {
  if (loading) return;
  loading = true;
  loader.style.display = "block";

  fetch("load_data.php?page=" + page)
    .then(response => response.text())
    .then(html => {
      if (html.trim() !== '') {
        document.getElementById("table-body").insertAdjacentHTML('beforeend', html);
        page++;
        loading = false;
        loader.style.display = "none";
      } else {
        loader.innerHTML = "მეტი მონაცემი აღარ არის.";
      }
    })
    .catch(error => {
      loader.innerHTML = "დაფიქსირდა შეცდომა.";
      console.error(error);
    });
}

// პირველადი ჩატვირთვა
loadData();

// როდესაც სკროლის ბოლოს მივა
window.addEventListener("scroll", () => {
  if ((window.innerHeight + window.scrollY) >= document.body.offsetHeight - 300) {
    loadData();
  }
});
</script>

</body>
</html>
