<?php
include '../13061981.php'; // კავშირი ბაზასთან
mysqli_set_charset($connection, 'utf8');

$limit = 100;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

$sql = "
  SELECT 
    h.pn AS pn, 
    h.status AS new_status, 
    m.statusn AS old_status, 
    h.period AS period, 
    h.reason AS reason,
    h.date AS subscription_date
  FROM socebi2 m
  INNER JOIN socebi h ON m.pnn = h.pn
  LIMIT $limit OFFSET $offset
";

$result = mysqli_query($connection, $sql);

if ($result && mysqli_num_rows($result) > 0) {
  while ($row = mysqli_fetch_assoc($result)) {
    $pn = htmlspecialchars($row['pn']);
    $new_status = htmlspecialchars($row['new_status']);
    $old_status = htmlspecialchars($row['old_status']);
    $period = htmlspecialchars($row['period']);
    $reason = htmlspecialchars($row['reason']);
    $date = htmlspecialchars($row['subscription_date']);
    $change = (trim($old_status) !== trim($new_status)) ? "შეიცვალა" : "არ შეცვლილა";

    echo "
    <tr>
      <td>$pn</td>
      <td>$new_status</td>
      <td>$old_status</td>
      <td>$change</td>
      <td>$period</td>
      <td>$reason</td>
      <td>$date</td>
    </tr>";
  }
}
?>
